<?php require 'includes/header.php'; ?>

<style>
  h4 {
    color: #0B0D60;
  }

  h5 {
    color: #4b6c34;
  }

  /* Card effect */
  .sec {
    margin-bottom: 30px;
  }

  figure.effect-steve {
    position: relative;
    overflow: hidden;
    margin: 0;
    background: #000;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    transition: transform 0.3s ease;
  }

  figure.effect-steve img {
    width: 100%;
    height: 250px;
    object-fit: cover;
    display: block;
    transition: transform 0.5s ease;
  }

  figure.effect-steve:hover img {
    transform: scale(1.1);
  }

  figure.effect-steve figcaption {
    padding: 20px;
    background: #fff;
    text-align: center;
  }

  figure.effect-steve h4 {
    margin-bottom: 10px;
    font-size: 18px;
    font-weight: bold;
  }

  figure.effect-steve p {
    font-size: 14px;
    line-height: 1.6;
    text-align: justify;
    color: #444;
  }

  /* Button style */
  .button7 {
    display: inline-block;
    padding: 8px 16px;
    background: #0B0D60;
    color: #fff !important;
    font-size: 14px;
    border-radius: 6px;
    transition: background 0.3s;
    text-decoration: none;
  }

  .button7:hover {
    background: #4b6c34;
    color: #fff !important;
  }

  /* Responsive fix */
  @media (max-width: 768px) {
    figure.effect-steve img {
      height: 200px;
    }
  }
</style>

<main class="main">

  <!-- Page Title -->
  <div class="page-title" data-aos="fade">
    <div class="container">
      <nav class="breadcrumbs">
        <ol>
          <li><a href="index.php">Home</a></li>
          <li class="current">About Mumbai</li>
        </ol>
      </nav>
    </div>
  </div>

  <section id="team" class="team section">
    <div class="container sub-header-titel aos-init aos-animate" data-aos="fade-up">
      <h2>About Mumbai</h2>

      <p style="padding-top: 15px;">
        Mumbai, formerly known as Bombay, is India's largest city and financial powerhouse. Situated on the west coast of India, Mumbai is a melting pot of cultures, diversity, and contrasts. It serves as the commercial, entertainment, and fashion capital of the country, pulsating with energy and vitality.<br><br>
        Mumbai, the capital of Maharashtra state is India’s largest city with a population of over 20.6 million it is equivalent to the population of so many countries of the world. Mumbai is set to be the world’s second largest urban conglomeration by 2025. Mumbai is the commercial capital of India.<br><br>
        Renowned for its iconic landmarks such as the Gateway of India, Marine Drive, and the historic Chhatrapati Shivaji Maharaj Terminus, Mumbai seamlessly blends its colonial past with modern aspirations. The city's skyline is adorned with towering skyscrapers, reflecting its status as a global business hub.<br><br>
        Mumbai is not just about its economic prowess; it is also a cultural hotspot. The city is home to Bollywood, the world's largest film industry, where dreams are woven into celluloid. From its vibrant street food scene to its upscale restaurants, Mumbai tantalizes taste buds with its culinary delights, including the famous vada pav and pav bhaji.
      </p>

      <div class="row">
        <!-- Gateway of India -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/gatewayofindia.jpg" alt="Gateway of India" />
            <figcaption>
              <h4>Gateway of India</h4>
              <p>Built in the 20th Century to commemorate the visit of King George V and Queen Mary, overlooking the Mumbai harbour.<br> 
                <a class="button7" href="https://maps.app.goo.gl/jAtX3gB25SVX44Ha9" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Bandra Worli Sea Link -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/discover-mumbai-bandra.jpg" alt="Bandra Worli Sea Link" />
            <figcaption>
              <h4>Bandra–Worli Sea Link</h4>
              <p>A 5.6 km long, 8-lane wide cable-stayed bridge linking Bandra with Worli.<br><br><br>
                <a class="button7" href="https://maps.app.goo.gl/vY1PudPTTnFj6wm48" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Kala Ghoda -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/discover-mumbai-kala-ghoda.jpg" alt="Kala Ghoda" />
            <figcaption>
              <h4>Kala Ghoda</h4>
              <p>Famous for art festivals, quirky boutiques and charming restaurants in South Mumbai.<br><br>
                <a class="button7" href="https://maps.app.goo.gl/7d5GBjEks7XD4Xns8" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Juhu & Chowpatty -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/juhu.jpg" alt="Mumbai Beach" />
            <figcaption>
              <h4>Mumbai Beach</h4>
              <p>Popular beaches include Juhu and Chowpatty, known for street food and sunset views.<br><br>
                <a class="button7" href="https://maps.app.goo.gl/LjDTnxWBnMJuA8UQ8" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Elephanta Caves -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/IMG_5604.jpg" alt="Elephanta Caves" />
            <figcaption>
              <h4>Elephanta Caves</h4>
              <p>One of the oldest rock-cut cave structures, showcasing Lord Shiva sculptures (6th–8th century).<br><br>
                <a class="button7" href="https://maps.app.goo.gl/oMZ6UefkGzWZKZdDA" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Atal Setu -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/atal.jpg" alt="Atal Setu" />
            <figcaption>
              <h4>Atal Setu</h4>
              <p>India’s longest sea bridge, 22 km long, inaugurated recently to connect Mumbai to South India.<br><br>
                <a class="button7" href="https://maps.app.goo.gl/HHYQ4fVSpUc9taHb8" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Colaba Causeway -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/30-2.jpg" alt="Colaba Causeway" />
            <figcaption>
              <h4>Colaba Causeway Market</h4>
              <p>Street shopping hub with clothes, boutiques, British-era buildings and eateries.<br><br>
                <a class="button7" href="https://maps.app.goo.gl/LRERoRvFn7cnXhkKA" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

        <!-- Dhobi Ghat -->
        <div class="col-md-3 sec">
          <figure class="effect-steve">
            <img src="image/images.jpeg" alt="Dhobi Ghat" />
            <figcaption>
              <h4>Mahalaxmi Dhobi Ghat</h4>
              <p>World’s largest open-air laundry, located near Mahalaxmi railway station.<br><br> <br>
                <a class="button7" href="https://maps.app.goo.gl/4ni5qskqQ4FQyfN8A" target="_blank">Get Direction</a>
              </p>
            </figcaption>
          </figure>
        </div>

      </div>
    </div>
  </section>

</main>

<?php require 'includes/footer.php'; ?>
